<?php

namespace App\Http\Resources\Web;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class BookedServicesResource extends JsonResource
{
    public static $wrap = null;
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $customer = $this->relationLoaded('customer') ? $this->whenLoaded('customer') : null;
        $therapist = $this->relationLoaded('therapist') ? $this->whenLoaded('therapist') : null;
        $therapist_community = $this->relationLoaded('therapist_community') ? $this->whenLoaded('therapist_community') : null;
        $service = $this->relationLoaded('service') ? $this->whenLoaded('service') : null;
        $service_status = $this->relationLoaded('service_status') ? $this->whenLoaded('service_status') : null;
        $messages = $this->relationLoaded('messages') ? $this->whenLoaded('messages') : null;
        $reviews = $this->relationLoaded('reviews') ? $this->whenLoaded('reviews') : null;
        return [
            "id" =>  $this->id,
            "customer_id" =>  $this->customer_id,
            "customer_name" => $customer ? $customer->name : null,
            "customer_image" => $customer ? $customer->image : null,
            "therapist_id" =>  $this->therapist_id,
            "therapist_name" => $therapist ? $therapist->name : null,
            "therapist_image" => $therapist ? $therapist->image : null,
            "therapist_community_id" =>  $this->therapist_community_id,
            "therapist_community_name" => $therapist_community ? $therapist_community->name : null,
            "therapist_community_image" => $therapist_community ? $therapist_community->image : null,
            "service_id" =>  $this->service_id,
            "service_name" => $service ? $service->name : null,
            "service_image" => $service ? $service->image : null,
            "service_status_name" => $service_status ? $service_status->display_name : null,
            "date" => Carbon::parse($this->date)->format('d/m/Y'),
            "started_at" =>  $this->started_at,
            "ended_at" =>  $this->ended_at,
            "price" =>  $this->price,
            "is_paid" =>  $this->is_paid,
            "question" =>  $this->question,
            "attachment_url" =>  $this->attachment_url,
            "service_status_code" =>  $this->service_status_code,
            "messages" => $messages ? MessagesResource::collection($messages):[],
            "reviews" => $reviews ? ServiceReviewsResource::collection($reviews):[],
            "created_at" =>  $this->created_at,
            "updated_at" =>  $this->updated_at,
        ];
    }
}
